#===========================================================
# ROBUST PARAMETER ESTIMATION USING BETA-DIVERGENCE METHOD #
#===========================================================
RobMeanVar<-function(xx)
   {
   Beta<-0.2
    Mo <- median(xx)
    Vo <- 1
    DiffTol = 0.0001;
    DiffNorm = +10000;
    Iter = 0;
      while (DiffNorm > DiffTol)
      {
      Wt <- exp(-(Beta*(xx-Mo)^2)/(2*Vo))  
      Wt[which(Wt==0)]=0.000001
      while((sum(Wt<0.2)/length(Wt))>0.5)
      {Beta<-Beta-0.02;
      if(Beta<=0){Beta=.001}
      Wt <- exp(-(Beta*(xx-Mo)^2)/(2*Vo)) # Calculation of weights for each observation
      Wb<-sum(Wt<0.2)/length(Wt)
#      cat("Beta=",Beta,"\n")
#      cat("Wb=",Wb,"\n")
      }
      M.new <-  sum(Wt*xx)/sum(Wt) # Robust mean function
      V.new <- sum(Wt*(xx-Mo)^2)/sum(Wt) # Robust variance function
      DiffNorm <- sqrt(sum((M.new-Mo)^2))+sqrt(sum((V.new-Vo)^2))
      Mo = M.new
      Vo = V.new
      sd = sqrt(V.new)
      Iter = Iter + 1 
      } #END of while

###### Threshold Estimation based on sample observation

   SimWt<-NULL
   for (tt in 1:100)
   {
   SimD<-rnorm(length(xx),Mo,sqrt(Vo))
   Wt.out<- exp(-(Beta*(SimD-Mo)^2)/(2*Vo))
   SimWt<-c(SimWt,Wt.out)
   }
out.Thr<-quantile(SimWt,10^-5)
  if (min(Wt)<out.Thr) # if minimum weight for an observation less than the estimated, 
                       # will take robust mean and variance otherwise classical mean and variance threshold 
     {M=Mo; V=Vo}
  else
  {M=mean(xx); V=var(xx)*(length(xx)-1)/length(xx)} # if no outlier
out<-as.integer(which(Wt<out.Thr))
Wt.out<-Wt[out]
#===========We can modified data by replacing unusual 
#           obserbations with robust mean/median of samples===================
for (i1 in 1:length(Wt))
     { if(Wt[i1] < out.Thr)
          {xx[i1] <- M.new}
}
return(list(xx=xx,mu=M, Var=V, sd=sqrt(V),out=out,Wt=Wt,
       Wt.out=Wt.out,SimWt=SimWt,out.Thr=out.Thr))
}


est.s0 <- function(tt, sd, s0.perc = seq(0, 1, by = 0.05)) {
      #tt=init.fit$tt;sd=init.fit$sd;
	## estimate s0 (exchangeability) factor for denominator.
	## returns the actual estimate s0 (not a percentile)
	br = unique(quantile(sd, seq(0, 1, len = 101)))
	nbr = length(br)
	a <- cut(sd, br, labels = F)
	a[is.na(a)] <- 1
	cv.sd <- rep(0, length(s0.perc))
     	for (j in 1:length(s0.perc)) {
		w <- quantile(sd, s0.perc[j])
		w[j == 1] <- 0
		tt2 <- tt * sd/(sd+w)
		tt2[tt2 == Inf] = NA
		sds <- rep(0, nbr - 1)
		for (i in 1:(nbr - 1)) {c
			sds[i] <- mad(tt2[a == i], na.rm = TRUE)
		}
		cv.sd[j] <- sqrt(var(sds))/mean(sds)
	}
	o = (1:length(s0.perc))[cv.sd == min(cv.sd)]
	# we don;t allow taking s0.hat to be 0th percentile when
	#   min sd is 0
	s0.hat = quantile(sd[sd != 0], s0.perc[o])
	return(list(s0.perc = s0.perc, cv.sd = cv.sd, s0.hat = s0.hat))
}

Sim2Group<-function(ng,n1,n2,var0=0.1,pde=0.05)
{
sz<-c(n1,n2);
TrueDE <-rep(c(1,0),c(ng*pde,(ng-(ng*pde))))
    mu1 <- runif(ng, min = 2, max =5)
    mu2.de <- runif(ng, min = 2, max =5)#
    mu2 <- mu1
    DEt<-which(TrueDE==1)
    DEmu1<-DEt[1:round((ng*pde)/2)]
    DEmu2<-DEt[(length(DEmu1)+1):ng*pde]
    mu1[DEmu1] <- mu1[DEmu1]+3
    mu2[DEmu2] <- mu2.de[DEmu2]+3
    DataMat<-matrix(NA,ng,sum(sz))

    for (jj in 1:length(TrueDE))
      {
        DataMat[jj,]<-c(mu1[jj]+rnorm(sz[1],0,var0), 
                        mu2[jj]+rnorm(sz[2],0,var0))
      }
    return(list(outmat = DataMat, DEtrue=TrueDE))
}

paired.ttest.func <- function(x, y, s0 = 0, sd = NULL) {
	nc <- ncol(x)/2
	o <- 1:nc
	o1 <- rep(0, ncol(x)/2)
	o2 <- o1
	for (j in 1:nc) {
		o1[j] <- (1:ncol(x))[y == -o[j]]
	}
	for (j in 1:nc) {
		o2[j] <- (1:ncol(x))[y == o[j]]
	}
	d <- x[, o2, drop = F] - x[, o1, drop = F]
	su <- x[, o2, drop = F] + x[, o1, drop = F]

        #Calculate robust mean and variance  

        xx_up=apply(d,1,RobMeanVar)
        rmean<-rvar<-NULL;
        for (p1 in 1:nrow(x)){
           rmean[p1]<-unlist(unique(xx_up[[p1]][2]))
           rvar[p1]<-unlist(unique(xx_up[[p1]][3]))
        }

        m<-rmean
              
	if (is.null(sd)) {
        sd<- sqrt(rvar/nc)#Robust standard deviation by Beta-Divergence method
      	}
	dif.obs <- m/(sd + s0)
	return(list(tt = dif.obs, numer = m, sd = sd))
}


insert.value <- function(vec, newval, pos) {
	if (pos == 1) 
		return(c(newval, vec))
	lvec <- length(vec)
	if (pos > lvec) 
		return(c(vec, newval))
	return(c(vec[1:pos - 1], newval, vec[pos:lvec]))
}

permute <- function(elem) {
	# generates all perms of the vector elem
	if (!missing(elem)) {
		if (length(elem) == 2) 
			return(matrix(c(elem, elem[2], elem[1]), nrow = 2))
		last.matrix <- permute(elem[-1])
		dim.last <- dim(last.matrix)
		new.matrix <- matrix(0, nrow = dim.last[1] * (dim.last[2] + 
			1), ncol = dim.last[2] + 1)
		for (row in 1:(dim.last[1])) {
			for (col in 1:(dim.last[2] + 1)) new.matrix[row + 
				(col - 1) * dim.last[1], ] <- insert.value(last.matrix[row, 
				], elem[1], col)
		}
		return(new.matrix)
	}
	else cat("Usage: permute(elem)\n\twhere elem is a vector\n")
}

permute.rows <- function(x) {
	dd <- dim(x)
	n <- dd[1]
	p <- dd[2]
	mm <- runif(length(x)) + rep(seq(n) * 10, rep(p, n))
	matrix(t(x)[order(mm)], n, p, byrow = TRUE)
}

sample.perms <- function(elem, nperms) {
	# randomly generates  nperms of the vector elem
	res = permute.rows(matrix(elem, nrow = nperms, ncol = length(elem), 
		byrow = T))
	return(res)
}

integer.base.b <- function(x, b = 2) {
	xi <- as.integer(x)
	if (xi == 0) {
		return(0)
	}
	if (any(is.na(xi) | ((x - xi) != 0))) 
		print(list(ERROR = "x not integer", x = x))
	N <- length(x)
	xMax <- max(x)
	ndigits <- (floor(logb(xMax, base = 2)) + 1)
	Base.b <- array(NA, dim = c(N, ndigits))
	for (i in 1:ndigits) {
		#i <- 1
		Base.b[, ndigits - i + 1] <- (x%%b)
		x <- (x%/%b)
	}
	if (N == 1) 
		Base.b[1, ]
	else Base.b
}

compute.block.perms = function(y, blocky, nperms) {
	# y are the data (eg class label 1 vs 2; or -1,1, -2,2 for
	#   paired data)
	# blocky are the block labels (abs(y) for paired daatr)
	ny = length(y)
	nblocks = length(unique(blocky))
	tab = table(blocky)
	total.nperms = prod(factorial(tab))
	# block.perms is a list of all possible permutations
	block.perms = vector("list", nblocks)
	# first enumerate all perms, when possible
	if (total.nperms <= nperms) {
		all.perms.flag = 1
		nperms.act = total.nperms
		for (i in 1:nblocks) {
			block.perms[[i]] = permute(y[blocky == i])
		}
		kk = 0:(factorial(max(tab))^nblocks - 1)
		#the rows of the matrix outerm runs through the 'outer
		#   product'
		# first we assume that all blocks have max(tab) members;
		#   then we remove rows of outerm that
		#  are illegal (ie when a block has fewer members)
		outerm = matrix(0, nrow = length(kk), ncol = nblocks)
		for (i in 1:length(kk)) {
			kkkk = integer.base.b(kk[i], b = factorial(max(tab)))
			if (length(kkkk) > nblocks) {
				kkkk = kkkk[(length(kkkk) - nblocks + 1):length(kkkk)]
			}
			outerm[i, (nblocks - length(kkkk) + 1):nblocks] = kkkk
		}
		outerm = outerm + 1
		# now remove rows that are illegal perms
		ind = rep(TRUE, nrow(outerm))
		for (j in 1:ncol(outerm)) {
			ind = ind & outerm[, j] <= factorial(tab[j])
		}
		outerm = outerm[ind, , drop = F]
		# finally, construct permutation matrix from outer product
		permsy = matrix(NA, nrow = total.nperms, ncol = ny)
		for (i in 1:total.nperms) {
			junk = NULL
			for (j in 1:nblocks) {
				junk = c(junk, block.perms[[j]][outerm[i, j], 
				  ])
			}
			permsy[i, ] = junk
		}
	}
	# next handle case when there are too many perms to
	#   enumerate
	if (total.nperms > nperms) {
		all.perms.flag = 0
		nperms.act = nperms
		permsy = NULL
		block.perms = vector("list", nblocks)
		for (j in 1:nblocks) {
			block.perms[[j]] = sample.perms(y[blocky == j], nperms = nperms)
		}
		for (j in 1:nblocks) {
			permsy = cbind(permsy, block.perms[[j]])
		}
	}
	return(list(permsy = permsy, all.perms.flag = all.perms.flag, 
		nperms.act = nperms.act))
}

rsam <-function (data,n1,s0 = NULL,s0.perc = NULL,nperms = 10,esamp = 20,nresamp.perm = NULL,log2=0) 
{

    if (log2) {
        data0<-log2(data)
    }
    else {
        data0<-data
    }

    m1=n1;m2=ncol(data0)-m1;n=nrow(data0)

    ystar = NULL
    perms = NULL
    permsy = NULL
    nperms.act = nperms
        
    x = data0
    y = c(seq(-1,-ncol(x)/2,by=-1),seq(1,ncol(x)/2,by=1))

    argy = y

    y = as.numeric(y)
    sd.internal = NULL
        
    stand.contrasts = NULL
    stand.contrasts.95 = NULL
            
    n <- nrow(x)
    ny <- length(y)
    sd <- NULL
    numer <- NULL
    init.fit <- paired.ttest.func(x,y,sd = sd.internal)
    numer <- init.fit$numer
    RFC<-numer 
    sd <- init.fit$sd
        if (is.null(s0)) {
            if (!is.null(s0.perc)) {
                if ((s0.perc != -1 & s0.perc < 0) | s0.perc > 
                  100) {
                  stop("Illegal value for s0.perc: must be between 0 and 100, or equal\nto (-1) (meaning that s0 should be set to zero)")
                }
                if (s0.perc == -1) {
                  s0 = 0
                }
                if (s0.perc >= 0) {
                  s0 <- quantile(init.fit$sd, s0.perc/100)
                }
            }
            if (is.null(s0.perc)) {
                s0 = est.s0(init.fit$tt, init.fit$sd)$s0.hat
                s0.perc = 100 * sum(init.fit$sd < s0)/length(init.fit$sd)
            }
        }
        
        tt <- paired.ttest.func(x,y,s0 = s0, sd = sd.internal)$tt
      #  permsy = matrix(NA, nrow = nperms.act, ncol = length(y))
       # for (i in 1:nperms.act) {
       #      permsy[i, ] = sample(c(-1, 1), size = length(y),replace = TRUE)
       # }     


       junk = compute.block.perms(y, abs(y), nperms)
       permsy = junk$permsy
       all.perms.flag = junk$all.perms.flag
       nperms.act = junk$nperms.act
       
        sdstar.keep <- NULL
        ttstar <- matrix(0, nrow = nrow(x), ncol = nperms.act)
        xstar <- x
        first = 1
        last = nperms.act
        
     for (b in first:last) {
            ystar = permsy[b, ]
            ttstar[, b] <- paired.ttest.func(xstar,ystar ,s0 = s0, sd = sd.internal)$tt
     }

for (j in 1:ncol(ttstar)) {
            ttstar[, j] <- -1 * sort(-1 * ttstar[, j])
        }
        for (i in 1:nrow(ttstar)) {
            ttstar[i, ] <- sort(ttstar[i, ])
    }

    return(list(x=x,tt = tt, sd = sd + s0,s0 = s0, s0.perc = s0.perc,ttstar = ttstar,RFC=RFC))
}

rsam.pvalues.from.perms = function(tt, ttstar) {
	r = rank(c(abs(tt), abs(as.vector(ttstar))))[1:length(tt)]
	r2 = rank(c(abs(tt)))
	r3 = r - r2
	pv = (length(tt) - r3/ncol(ttstar) + 1)/length(tt)
	return(pv)
}

TopN_Thr2<-function(rTstat,rFC,TopN){

score0<-NULL

mm=length(rTstat)

pindex=rank(abs(rTstat))
mindex=rank(abs(rFC))

for (kk in 1:mm){
score0[kk]<-sum(pindex[kk],mindex[kk])
}

TopDEgene<-sort(score0,decreasing=TRUE,index.return=TRUE)$ix[1:TopN]

return(list(DE_index=TopDEgene,score=score0))
}


################ ROC analysis #####################
Rate.FDR.TopG<-function(PostP,de.true,TopG,decreasing=TRUE)
{
library(ROC)
library(ROCR)
m=length(TopG);
FDRo=rep(0,m); TPRo=rep(0,m);FPRo=rep(0,m);FDRo=rep(0,m);TNRo=rep(0,m);
FNRo=rep(0,m); ERo=rep(0,m); #auc<-rep(0,m);paucp2<-rep(0,m)
TP<-rep(0,m);FP<-rep(0,m);TN<-rep(0,m);FN<-rep(0,m)
for (ii in 1:m) 
{
Porder<-sort(PostP, decreasing, index.return=TRUE)
Top_pIdx<-Porder$ix
TP[ii] <- length(intersect(Top_pIdx[1:TopG[ii]], which(de.true==T)));
FP[ii] <- length(intersect(Top_pIdx[1:TopG[ii]], which(de.true==F)));
TN[ii] <- length(intersect(Top_pIdx[-(1:TopG[ii])], which(de.true==F)));
FN[ii] <- length(intersect(Top_pIdx[-(1:TopG[ii])], which(de.true==T)));
TPRo[ii]<-TP[ii]/(TP[ii]+FN[ii]);       #True positive rate
if((TP[ii]+FN[ii])==0){TPRo[ii]=0}
TNRo[ii]<-TN[ii]/(TN[ii]+FP[ii]);       #True negative rate
if((TN[ii]+FP[ii])==0){TNRo[ii]=0}
FPRo[ii]<-FP[ii]/(TN[ii]+FP[ii]);        #False positive rate
if((TN[ii]+FP[ii])==0){FPRo[ii]=0}
FNRo[ii]<-FN[ii]/(TP[ii]+FN[ii]);        #False negative rate
if((TP[ii]+FN[ii])==0){FNRo[ii]=0}
FDRo[ii] <-FP[ii]/(TP[ii]+FP[ii]);       #False Discovery rate
if((TP[ii]+FP[ii])==0){FDRo[ii]=0};
ERo[ii]<-(FP[ii]+FN[ii])/length(PostP); #MisClassification Rate
}
R1 <- rocdemo.sca(rbinom(40,1,.3), rnorm(40), dxrule.sca, 
      caseLabel="new case", markerLabel="demo Marker" )
R1@sens<-TPRo; #Sensitivity
R1@spec<-(1-FPRo);#Specificity 
R1@cuts<-as.numeric(c("Inf",sort(seq(0,0.99999,length=length(PostP)),decreasing=T)))
auc<-AUC(R1); # AUC
paucp2<- pAUC(R1,0.2)# pAUC upto FPR<=0.2
list(TP=TP,TN=TN,FP=FP,FN=FN,R1=R1,TPR=TPRo,TNR=TNRo,FPR=FPRo,FNR=FNRo,
     FDR=FDRo,ER=ERo,AUC2=auc,pAUC2=paucp2)
}











